/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships;

import com.talhanation.smallships.client.events.ClientRegistry;
import com.talhanation.smallships.client.events.KeyEvents;
import com.talhanation.smallships.client.events.PlayerEvents;
import com.talhanation.smallships.client.events.RenderEvents;
import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.init.ModEntityTypes;
import com.talhanation.smallships.init.SoundInit;
import com.talhanation.smallships.items.ModItems;
import com.talhanation.smallships.network.MessageDismount;
import com.talhanation.smallships.network.MessageIsForward;
import com.talhanation.smallships.network.MessageOpenInv;
import com.talhanation.smallships.network.MessagePaddleState;
import com.talhanation.smallships.network.MessageSailState;
import com.talhanation.smallships.network.MessageSteerState;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

@Mod(value="smallships")
public class Main {
    public static final String MOD_ID = "smallships";
    public static SimpleChannel SIMPLE_CHANNEL;
    public static KeyBinding SAIL_KEY;
    public static KeyBinding SAIL_L_KEY;
    public static KeyBinding SAIL_H_KEY;
    public static KeyBinding INV_KEY;
    public static KeyBinding DISMOUNT_KEY;

    public Main() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, SmallShipsConfig.CONFIG);
        SmallShipsConfig.loadConfig(SmallShipsConfig.CONFIG, FMLPaths.CONFIGDIR.get().resolve("smallships-common.toml"));
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        SoundInit.SOUNDS.register(modEventBus);
        ModItems.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModEntityTypes.ENTITY_TYPES.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup));
    }

    private void setup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        SIMPLE_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MOD_ID, "default"), () -> "1.0.0", s -> true, s -> true);
        SIMPLE_CHANNEL.registerMessage(0, MessagePaddleState.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessagePaddleState().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(1, MessageSailState.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageSailState().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(2, MessageSteerState.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageSteerState().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(3, MessageOpenInv.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageOpenInv().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(4, MessageIsForward.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageIsForward().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(5, MessageDismount.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageDismount().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new RenderEvents());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEvents());
        MinecraftForge.EVENT_BUS.register((Object)new KeyEvents());
        SAIL_KEY = ClientRegistry.registerKeyBinding("key.ship_sail", "category.smallships", 82);
        INV_KEY = ClientRegistry.registerKeyBinding("key.ship_inventory", "category.smallships", 73);
        SAIL_L_KEY = ClientRegistry.registerKeyBinding("key.lower_ship_sail", "category.smallships", 74);
        SAIL_H_KEY = ClientRegistry.registerKeyBinding("key.higher_ship_sail", "category.smallships", 75);
    }
}

